<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class RepositoryWebrefLinkKindInfo extends \Google\Model
{
  protected $flagsType = RepositoryWebrefLinkKindFlags::class;
  protected $flagsDataType = '';
  /**
   * @var string
   */
  public $topicPropertyName;

  /**
   * @param RepositoryWebrefLinkKindFlags
   */
  public function setFlags(RepositoryWebrefLinkKindFlags $flags)
  {
    $this->flags = $flags;
  }
  /**
   * @return RepositoryWebrefLinkKindFlags
   */
  public function getFlags()
  {
    return $this->flags;
  }
  /**
   * @param string
   */
  public function setTopicPropertyName($topicPropertyName)
  {
    $this->topicPropertyName = $topicPropertyName;
  }
  /**
   * @return string
   */
  public function getTopicPropertyName()
  {
    return $this->topicPropertyName;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RepositoryWebrefLinkKindInfo::class, 'Google_Service_Contentwarehouse_RepositoryWebrefLinkKindInfo');
